Review

# What Is the Impact of ChatGPT on Education? A Rapid Review of the Literature

Chung Kwan Lo $\textcircled{1}$

Citation: Lo, C.K. What Is the Impact of ChatGPT on Education? A Rapid Review of the Literature. Educ. Sci. 2023, 13, 410. https://doi.org/ 10.3390/educsci13040410

Academic Editor: Maiga Chang

Received: 13 March 2023   
Revised: 6 April 2023   
Accepted: 13 April 2023   
Published: 18 April 2023

Department of Mathematics and Information Technology, The Education University of Hong Kong, Hong Kong SAR 999077, China; chungkwanlo@eduhk.hk

Abstract: An artificial intelligence-based chatbot, ChatGPT, was launched in November 2022 and is capable of generating cohesive and informative human-like responses to user input. This rapid review of the literature aims to enrich our understanding of ChatGPT’s capabilities across subject domains, how it can be used in education, and potential issues raised by researchers during the first three months of its release (i.e., December 2022 to February 2023). A search of the relevant databases and Google Scholar yielded 50 articles for content analysis (i.e., open coding, axial coding, and selective coding). The findings of this review suggest that ChatGPT’s performance varied across subject domains, ranging from outstanding (e.g., economics) and satisfactory (e.g., programming) to unsatisfactory (e.g., mathematics). Although ChatGPT has the potential to serve as an assistant for instructors (e.g., to generate course materials and provide suggestions) and a virtual tutor for students (e.g., to answer questions and facilitate collaboration), there were challenges associated with its use (e.g., generating incorrect or fake information and bypassing plagiarism detectors). Immediate action should be taken to update the assessment methods and institutional policies in schools and universities. Instructor training and student education are also essential to respond to the impact of ChatGPT on the educational environment.

Keywords: ChatGPT; OpenAI; artificial intelligence; natural language processing; chatbot

# 1. Introduction

Artificial intelligence (AI) has developed rapidly in recent years, leading to various applications in different disciplines, such as healthcare [1] and education [2]. AI systems can be trained to simulate the human brain and carry out routine work using large amounts of data [3]. In healthcare, for example, AI can aid professionals in their work by synthesising patient records, interpreting diagnostic images, and highlighting health concerns [4]. AI applications have also been utilised in education to enhance administrative services and academic support [2]. One representative example is intelligent tutoring systems (ITS), which can be used to simulate one-to-one personal tutoring. The results of a meta-analysis indicated that ITS generally had a moderately positive effect on the academic achievement of college students [5]. However, the development of ITS can be challenging, as it involves not only content creation and design but also the refinement of feedback phrasing and dialogue strategies [6].

ChatGPT, a recently developed conversational chatbot created by OpenAI [7], may make it easier for instructors to apply AI in teaching and learning. ChatGPT uses natural language processing to generate human-like responses to user input. It has gained attention worldwide for its impressive performance in generating coherent, systematic, and informative responses [8]. In a surprising achievement, ChatGPT passed four separate examinations at the University of Minnesota Law School [9]. Although its scores were not (yet) very good, the results demonstrate that this AI application is capable of earning a university degree [10]. Since its release on 30 November 2022, ChatGPT has become the fastest-growing user application in history, reaching 100 million active users as of January 2023, just two months after its launch [11].

Despite its success, ChatGPT has introduced new challenges and threats to education. With its ability to provide specific answers to user questions, it can be used to complete written assignments and examinations on behalf of students, leading to concerns about AI-assisted cheating. In response, some schools have banned access to ChatGPT on campus [12]. The implications of GhatGPT in the field of education were explored in a review by Mhlanga [13]. He analysed eight articles on ChatGPT and revealed that educators had concerns regarding the use of ChatGPT in education. They expressed worries that students may outsource their work to ChatGPT because of its ability to rapidly generate acceptable texts. Therefore, Mhlanga [13] emphasised the importance of the responsible and ethical use of ChatGPT. Sallam [14] reviewed 60 articles on ChatGPT in the fields of healthcare, medical education, and academia. He found various concerns across the studies, ranging from plagiarism to incorrect responses and inaccurate citations. Therefore, the implications of ChatGPT-assisted learning require immediate attention to ensure that its benefits are optimised while its drawbacks are minimised.

Although Mhlanga [13] and Sallam [14] shed some light on the concerns regarding the use of ChatGPT, a more comprehensive review is needed to gain a deeper understanding of its potential benefits and threats to education. Furthermore, current knowledge about ChatGPT’s capabilities comes mainly from media reports (e.g., [9,15]). It is necessary to examine the results of research on ChatGPT to evaluate its true performance across different subject domains. Hence, the following research questions (RQ1 to RQ3) are posed to guide the review.

• RQ1: How does ChatGPT perform in different subject domains? RQ2: How can ChatGPT be used to enhance teaching and learning? RQ3: What are the potential issues associated with ChatGPT, and how can they be addressed?

# 2. Methods

# 2.1. The Rapid Review Approach

As ChatGPT continues to receive great attention and is increasingly used by students, there is a pressing need to understand its impact on education and take immediate action in response to its possible threats. However, a comprehensive systematic review can take several months or even years to conduct [16,17], which is not ideal for catching up with the rapidly evolving ChatGPT landscape. Therefore, a rapid review approach was used. According to Tricco et al. [17], “a rapid review is a type of knowledge synthesis in which components of the systematic review process are simplified or omitted to produce information in a short period of time” (p. 2). This approach enabled a timely synthesis and overview of recently published articles and their key findings. Accordingly, this review could provide valuable insights enabling researchers, practitioners, and policymakers to respond promptly to the influence of ChatGPT on the field of education.

# 2.2. Search Strategies

This rapid review followed the Preferred Reporting Items for Systematic Reviews and Meta-Analysis (PRISMA) statement when selecting relevant articles [18]. The final search was conducted on 28 February 2023 (i.e., three months after the release of ChatGPT). Therefore, the ChatGPT involved in these articles was its original release (dated 30 November 2022) based on Generative Pre-trained Transformer 3.5 (GPT-3.5). Seven electronic databases were used: (1) Academic Search Ultimate, (2) ACM Digital Library, (3) Education Research Complete, (4) ERIC, (5) IEEE Xplore, (6) Scopus, and (7) Web of Science. The search string “ChatGPT” was used in each database to search for relevant articles that included the term “ChatGPT” in their title, abstract, or keywords. The publication period was specified as 2022 to the present. Despite the use of multiple databases, only a limited number of relevant articles were found. Therefore, a title search for the term “ChatGPT” was conducted using Google Scholar within the same publication period. This approach enabled the retrieval of additional relevant articles that were not captured in the initial database search.

# 2.3. Inclusion and Exclusion Criteria

Academic articles published between 1 January 2022 and 28 February 2023 (the date of the final search) were reviewed, including advanced online publications and preprints. Non-academic articles (e.g., articles from mass and social media) were excluded. At the time of writing, this period covered all of the articles that had been published about ChatGPT, as it was released on 30 November 2022. To be included in this rapid review, articles had to discuss ChatGPT in the field of education, with no constraints on any specific educational contexts. Literature reviews, if retrieved, were used as background references. However, they were excluded from the synthesis to avoid duplicate findings. In addition, only English-language articles were included in this review. Table 1 summarises the inclusion and exclusion criteria for article selection.

Table 1. Inclusion and exclusion criteria for article selection.   

<html><body><table><tr><td>Criterion</td><td>Inclusion</td><td>Exclusion</td></tr><tr><td>Article topic</td><td>Discuss ChatGPT in the field</td><td>Do nt disdof eGhatGPT in he</td></tr><tr><td>Article type</td><td>Academic articles</td><td>Non-academic articles, such as articles from mass and social media</td></tr><tr><td>Time period</td><td>1 January 2022 to 28 February 2023</td><td>Articles outside the time period</td></tr><tr><td>Language</td><td>English</td><td>Non-English</td></tr></table></body></html>

# 2.4. Content Analysis

Guided by the research questions set forth above, a content analysis of the included articles was conducted. Creswell’s [19] coding techniques were employed in the process of analysis and interpretation. His approach comprised of the following three main stages.

1. Open coding: Open coding is the initial stage of coding in which the researcher examines the data and generates codes to describe and categorise the data. It allows a deep exploration and understanding of the data without imposing preconceived ideas.   
2. Axial coding: After the initial process of open coding, axial coding is used to analyse the relationships and connections between the codes generated during open coding. It involves organising the codes into broader categories or themes and establishing the relationships between them.   
3. Selective coding: Selective coding is the final stage of coding. It involves further refining and integrating the categories or themes identified during open and axial coding to develop a comprehensive picture. It identifies the core category or central phenomenon that emerged from the data.

Following Creswell’s [19] approach, codes were assigned to pieces of data without using predominant frameworks in the stage of open coding. After the completion of coding the first 15 articles, all the codes assigned were reviewed and grouped by similarity, thereby reducing redundant codes in the stage of axial coding. The preliminary list of codes was used to analyse the remaining articles. Hence, any new codes that emerged were added to the list. Specific quotes were identified to further support the codes. Finally, similar codes were organised into categories in the stage of selective coding. To enhance the consistency of classification, several exemplary quotes that clearly illustrated each category were identified. Multiple reviews of the data were performed to maintain consistency in coding.

# 3. Findings

# 3.1. General Description of the Literature

Figure 1 shows that 50 and 367 outcomes were retrieved through the database search and Google Scholar, respectively. Due to duplication across databases and Google Scholar, some of the articles were removed, yielding 363 unique records for screening. Notably, many records retrieved were outside the scope of this review, including articles from mass and social media found by Google Scholar. After reviewing the unique records’ titles, abstracts,cles were then excluded: (1) two articles that were not related to educatio and publication sources, 55 full-text articles were assessed for eligibility. Five articles wereprint article that was incomplete, and (3) two articles that were literature then excluded: (1) two articles that were not related to education, (2) one preprint article that was incomplete, and (3) two articles that were literature reviews. However, some of the excluded articles were used as background references. Ultimately, 50 articles [8,10,20–67] were selected for synthesis. The list of the included articles is provided in the Supplementaryin the Supplementary Materials. Figure 1 provides an overview of the a Materials. Figure 1 provides an overview of the article selection process.process.

![](images/eb485e3d51976b2d945f5890d3163197ba22a89c6940fd7bd5638a21b1112ad4.jpg)  
Figure 1. PRISMA flow diagram of article Figure 1. PRISMA flow diagram of article selection.

As shown in Figure 2, the majority of the included articles were written by researchers As shown in Fifrom the United States $( N = 1 9 )$ , the majority of the included a), followed by the United Kingdom $( N = 4 )$ were writt and Austria $( N = 3 )$ om the United States (N = 19), followed b. Figure 3 shows that 16 of the 50 included articles $( 3 2 \% )$ e United Kingdom (N = were published in journals, (N = 3). Figure 3 shows that 16 oand two were published as an eBook $( 2 \% )$ 50 includ and report $( 2 \% )$ rticles (32%) were publis, respectively. The remaining 32 articlesIEW $( 6 4 \% )$ were preprints uploaded on SSRN [68] $N = 1 2 ,$ ), followed by arXiv [69]5 of 16 $( N = 7 )$ and ResearchGate [70] $( N = 5 )$ , among others.

![](images/cb00c06947987b807ef09f32028f19b231db26f6fbed65ef5b45a680ca1044a8.jpg)  
Figure 2. Countries/locations of the included articles Figure 2. Countries/locations of the included articles $( N = 5 0 )$ . .

![](images/6721c50dc2b14b8b2bfa959b1baa18edce2150bcdca0922e138cfc798d4acf4a.jpg)  
Figure 3. Publication sources of the included articles (N = 50Figure 3. Publication sources of the included articles $( N = 5 0 )$ ).

3.2. RQ1: How Does ChatGPT Perform in Different Subject Domains? 3.2. RQ1: How Does ChatGPT Perform in Different Subject Domains?

s shown in Table 2, ChatGPT-3.5As shown in Table 2, ChatGPT- $3 . 5 \mathrm { ^ / s }$ rformance was evaluated in 21 studies using  performance was evaluated in 21 studies using tests, tests, exams, or interviews. All of these studies, except for de Winter’s [20] study that used exams, or interviews. All of these studies, except for de Winter’s [20] study that used high high school exams, were conducted in the context of higher education. ChatGPT’s perfor-school exams, were conducted in the context of higher education. ChatGPT’s performance varied across subject domains. It demonstrated outstanding results in critical and higher-order thinking [21] and economics [22]. However, its performance was not entirely satisfactory in other subject domains, such as law [10,23], medical education [24–32], and mathematics [33]. These results are consistent with Newton’s [34] study, which used multiple-choice questionsical education, law, and physics. In economics, ChatGPT outperformed average students, based exams to assess ChatGPT’s performance in economics, medical education, law, and but in other subjects, it underperformed average students by 8 to 40 points (out of 100). physics. In economics, ChatGPT outperformed average students, but in other subjects, it Notably, medical education was a subject domain for which there underperformed average students by 8 to 40 points (out of 100).

nce of ChatGPT’s performance. These results came from multiple countries. Kung et Notably, medical education was a subject domain for which there was relatively al. [24] and Gilson et al. [25] evaluated ChatGPT’s performance using the United States more evidence of ChatGPT’s performance. These results came from multiple countries. Medical Licensing Examination. Their results suggested that ChatGPT could yield mod-Kung et al. [24] and Gilson et al. [25] evaluated ChatGPT’s performance using the United erate accuracy and, thus, a passing score. However, Fijačko [26] found that ChatGPT failed States Medical Licensing Examination. Their results suggested that ChatGPT could yield the exams of the American Heart Association. Han et al. [27] noted that ChatGPT provided moderate accuracy and, thus, a passing score. However, Fijaˇcko [26] found that ChatGPT failed the exams of the American Heart Association. Han et al. [27] noted that ChatGPT provided incorrect and insufficient information about cardiovascular diseases. In the consources. In China, Wang et al. [29] testified ChatGPT using the Chinese National Medical text of pharmacology education in Malaysia, Nisar and Aslam [28] found that although Licensing Examination. They reported that ChatGPT’s performance was lower than med-ChatGPT could provide relevant and accurate answers, these answers lacked references ical students’ average score. Similar results were reported by researchers in Korea [30], and sources. In China, Wang et al. [29] testified ChatGPT using the Chinese National Medindia [31], and Singapore [32]. The findings of these studies suggested that, in general, cal Licensing Examination. They reported that ChatGPT’s performance was lower than ChatGPT’s performance was not entirely satisfactory in the domain of medical education. medical students’ average score. Similar results were reported by researchers in Korea [30], India [31], and Singapore [32]. The findings of these studies suggested that, in general, ChatGPT’s performance was not entirely satisfactory in the domain of medical education.

Table 2. Performance evaluation of ChatGPT-3.5 across subject domains (from high to low).   

<html><body><table><tr><td>Subject Domain</td><td>Studies</td><td>Perfverall.e</td><td>Representative Researcher Comments</td></tr><tr><td>Critical and higher-order thinking</td><td>[21]</td><td>Outstanding</td><td>&quot;Thee [21] (p. 13).</td></tr><tr><td>Economics</td><td>[22]</td><td> Outstanding</td><td>In TUCE,&quot;ChatGPT ranks at the 99th percentile in macroeconomics and the 91st percentile in microeconomics, when compared to [other] students&quot;[22] (p.7).</td></tr><tr><td> Programming</td><td>[35-37]</td><td>Outstandingto</td><td>“Nearly all answers of ChatGPT were completely correct and nicely out of 100 points,resulting in a grade of ‘Satisfactory&quot; [36] (p. 4).</td></tr><tr><td>English language comprehension</td><td>[20]</td><td> Satisfactory</td><td>&quot;the Netherlands&quot; [20](p. 1).</td></tr></table></body></html>

Table 2. Cont.   

<html><body><table><tr><td>Subject Domain</td><td>Studies</td><td>Performalce</td><td>Representative Researcher Comments</td></tr><tr><td>Law</td><td>[10,23]</td><td></td><td>&quot;ChatGPT performed on average at the level ofa C+ student,achieving a &quot;tperformed wosw butxasinhatrade&quot;[10](polem-styleor issue spotting&#x27;questions&quot; [23] (p. 1)</td></tr><tr><td>Medical education</td><td>[24-32]</td><td>Barelysatister</td><td>&quot;ChatGPT yields moderate accuracy approaching passing performance In American Heart AssciatonMLE&quot;[ 4A(PLS exams, &quot;ChatGPT d not reach the passing threshold for any of the exams&quot; [26] (p.109732).</td></tr><tr><td>Mathematics</td><td>[33]</td><td>Unsatisfactory</td><td>&quot;ChatGPT&#x27;smatheaiabisaresgnifiatybsl. ose oan</td></tr><tr><td> Software testing</td><td>[38]</td><td>Unsatisfactory</td><td>&quot;ChatGPT is not able, by itself, to pass a software testing course. In total, ChatGPT was able to correctly answer 37.5% of the questions we posed&quot; [38] (p. 8).</td></tr><tr><td>andpsychengy</td><td>[39]</td><td>Unsatisfactory</td><td>&quot;ChatGPTgave serlcorect eswrst pstiosbtfailethe test</td></tr><tr><td>MCQ-based exams</td><td>[34]</td><td>Unsatisfactory</td><td></td></tr></table></body></html>

ACLS $=$ Advanced Cardiovascular Life Support; BLS $=$ Basic Life Support; MCQ $=$ Multiple-choice questions; TUCE $=$ Test of Understanding in College Economics; USMLE $=$ United States Medical Licensing Examination.

# 3.3. RQ2: How Can ChatGPT Be Used to Enhance Teaching and Learning?

The findings of this review suggested that ChatGPT can serve as an assistant for both instructors and students. Concerning instructors, Table 3 categorises ChatGPT’s five major functions into two main aspects, namely teaching preparation (i.e., generating course materials, providing suggestions, and performing language translation) and assessment (i.e., generating assessment tasks and evaluating student performance).

Concerning the teaching preparation aspect, ChatGPT can make suggestions that assist instructors. In the words of one instructor, “ChatGPT can be a useful tool for teachers and educators to remind them of what knowledge and skills should be included in their curriculum, by providing an outline” [40] (pp. 7–8). Megahed et al. [37] asked ChatGPT to generate a course syllabus for an undergraduate statistics course. They noted that its teaching suggestions could be adopted without the need for major changes. Zhai [41] found that ChatGPT was able to provide recommendations related to special education. He commented, “These recommendations are beneficial for students with special learning needs” (p. 4).

Table 3. ChatGPT functions to support instructors in their teaching routines.   

<html><body><table><tr><td>Aspect</td><td>Function</td><td>Representative Quotes</td><td>Representative Suppot</td></tr><tr><td rowspan="3">preparation Teaching</td><td>Generating ourse</td><td>t</td><td>[43-45]</td></tr><tr><td>suggestions Providing</td><td>&quot;I told ChatGPT that the learner was with dyslexia,and eventually Chat</td><td>[8,27,37]</td></tr><tr><td>Performig lanuage</td><td>&quot;ChatGPt</td><td>[45,47,48]</td></tr><tr><td rowspan="2">Assessment</td><td>assessment tasks Generating</td><td>&quot;Another use of ChatGPT is its ability to generate exercises, quizzes, and scenarios which can be used in the classroom to aid in practice and assessment&quot; [29] (p. 5).</td><td>[27,45,49]</td></tr><tr><td>Evaluating student</td><td>Cee</td><td>[46,50,51]</td></tr></table></body></html>

Concerning the assessment aspect, ChatGPT can help instructors generate exercises, quizzes, and scenarios for student assessment [29,45]. However, Al-Worafi et al. [49] cautioned that the assessment tasks suggested by ChatGPT might not cover all targeted learning objectives. Therefore, they recommended using ChatGPT to guide instructors in their preparation of assessments rather than to completely replace their efforts. For example, Han et al. [27] instructed ChatGPT to create a multiple-choice question with a vignette and lab values for a medical topic. The question’s outcome was “a reasonable basic question to assess students’ knowledge” (p. 7). The instructors could refine the language of and information contained in the question to increase its relevancy to their course requirements.

For students, ChatGPT can serve as a virtual tutor to support their learning. Table 4 categorises its six major functions into two main aspects, namely learning (i.e., answering questions, summarising information, and facilitating collaboration) and assessment (i.e., concept checking and exam preparation, drafting assistance, and providing feedback).

Consider ChatGPT’s ability to facilitate collaboration in the learning aspect. Rudolph et al. [52] suggested that ChatGPT can generate different scenarios for students to work collaboratively in group activities. It can then provide a discussion structure, real-time feedback, and personalised guidance to facilitate group discussions and debates [44]. As noted by Gilson et al. [25], the enhanced small-group discourse in problem-solving benefits student learning.

Concerning the assessment aspect, students can benefit from using ChatGPT as a scaffolding tool for their initial draft and then refining the draft by correcting errors and adding references to the final versions of their written assignments [10,23]. Gilson et al. [25] noted that ChatGPT’s initial answer could prompt further questioning and encourage students to apply their knowledge and reasoning skills. However, Rudolph et al. [52] cautioned that ChatGPT should not replace critical thinking and original work but should instead serve as an aid to improve writing and research skills.

Table 4. ChatGPT functions to support student learning.   
3.4. RQ3: What Are the Potential Issues Associated with ChatGPT and How Can They Be Addressed?   

<html><body><table><tr><td>Aspect</td><td>Function</td><td>Representative Quotes</td><td> Representive Support</td></tr><tr><td rowspan="3">Learning</td><td>Answering questions</td><td>&quot;The answer[s] given by ChatGPT were relevant and accurate ... The tool can used as quick reference and self-studying instrument&quot; [28] (p. 1).</td><td>[25,46,53]</td></tr><tr><td>Summarising information</td><td>“The ChatGPT application has the potential to serve</td><td>[23,29,44]</td></tr><tr><td>Facilitating collaboration</td><td>as a means of generating different scenarios for students to work together to solve problems and achieve goals&quot; [52] (p. 13).</td><td>[25,44,50]</td></tr><tr><td rowspan="3">Assessment</td><td>Concept checking and exam preparation</td><td>&quot;ChatGPha shoen prmiself erninigeoing preparing for the life support exams&quot; [26] (p.1).</td><td>[10,28,32]</td></tr><tr><td>Drafting assistance</td><td>&quot;students could be encouraged to use AI to give a &#x27;first draft&#x27; answer,and then asked to improve upon that answer manually&quot; [23] (p. 21).</td><td>[10,25,55]</td></tr><tr><td>Providing feedback</td><td>ChadePcould suts ealimlp.</td><td>[46,48,56]</td></tr></table></body></html>

This review identified five major issues associated with ChatGPT in education. Table 5 categorises these issues into two main aspects, namely accuracy and reliability (i.e., relying on biased data, having limited up-to-date knowledge, and generating incorrect or fake information) and plagiarism prevention (i.e., student plagiarism and bypassing plagiarism detectors).

Table 5. Major potential issues associated with ChatGPT.   

<html><body><table><tr><td>Aspect</td><td>Issues</td><td>Representative quotes</td><td> Representative Suport</td></tr><tr><td rowspan="3">Aceurabiad</td><td>Relying on biased data</td><td>“These biases stem from research performed in high-incomecountries and textbooks [i.e, the training data of ChatGPT]&quot; [57] (p. 2).</td><td>[40,46,54]</td></tr><tr><td>Having limited up-to-date knowledge</td><td>&quot;ChatGPT has no idea of the world after 2021 and enceitld</td><td>[25,45,56]</td></tr><tr><td>Generating incorrect/fake information</td><td>&quot;ChatGPT included a make-up article which does not exist and even provided full bibliographic details of the article with a non-functional URL&quot; [46] (p. 14).</td><td>[32,38,58]</td></tr><tr><td rowspan="2">Plagiarism prevention</td><td> Student plagiarism</td><td>&quot;Our experimental group [with ChatGPT support] had slightly more problems with plagiarism than the control group [without ChatGPT support]&quot; [59] (p. 7).</td><td>[40,51,60]</td></tr><tr><td>Bypassing plagiarism detectors</td><td>&quot;Of the 50 essays inspected,the plagiarism-detection less&quot; [61] (p. 10).</td><td>[36,52,62]</td></tr></table></body></html>

Consider the issue of generating incorrect or fake information in the accuracy and reliability aspect. Mogali [32] raised concerns about ChatGPT’s well-written but inaccurate information. It has commonly been observed that the bibliographic citations generated by ChatGPT can be fake [32,39,46,56,58]. Concerning subject knowledge, Megahed et al. [37] found that it generated incorrect programming codes and was unable to detect and resolve its errors. This concern was echoed by Jalil et al. [38], who commented that “ChatGPT is a poor judge of its own correctness” (p. 8). ChatGPT’s accuracy and reliability have also been found to be questionable in other subject domains, such as mathematics [33], sports science and psychology [39], and health professions [26,27,32].

Concerning the plagiarism prevention aspect, ChatGPT-generated texts can bypass conventional plagiarism detectors. For example, Ventayen [62] asked ChatGPT to write an essay based on existing publications and checked its output for originality using Turnitin (a plagiarism detection application [71]). However, the application found a low similarity index between the document and existing work, and no plagiarism could be detected. Khalil and Er [61] asked ChatGPT to generate 50 essays based on different open-ended questions. Half of the essays were checked using Turnitin [71], which gave an average similarity score of $1 3 . 7 2 \%$ . The other half were checked using iThenticate [72], another plagiarism detection application, which gave an average similarity score of $8 . 7 6 \%$ . With these scores, the ChatGPT documents were considered highly original.

The included articles proposed several strategies to address the potential issues associated with ChatGPT in education. Table 6 categorises these strategies into three main aspects, namely task design (i.e., incorporating multimedia resources, adopting novel question types, and using digital-free assessment formats), the identification of AI writing (i.e., using AI-based writing detection tools and checking references), and institutional policy (i.e., establishing anti-plagiarism guidelines and providing student education).

Table 6. Strategies in response to plagiarism issues created by ChatGPT.   

<html><body><table><tr><td>Aspect</td><td>Strategies</td><td>Representative Quotes</td><td>Other Representative Support</td></tr><tr><td rowspan="3">Task design</td><td>Incorporating multimedia resources</td><td>&quot;Embedding images to exam questions can make it more difcult for students to cheat and for ChatGPT to generate accurate responses&quot;[21](p.16).</td><td>[22,34,52]</td></tr><tr><td>Adopting novel question types</td><td>&quot;[Instructors] might also reconsider the types of eiyt [a] recall of legal rules&quot;[10] (p. 12).</td><td>[8,22,63]</td></tr><tr><td>Employinend igital-free</td><td>&quot;blanket solution would be to make all assessments of the&#x27;in-ChatGPrrt.itwil dinanuial ipulouible fashion&quot; [23] (p.19).</td><td>[21,31,36]</td></tr><tr><td rowspan="2">Identification of AI writing</td><td>Using Albiond writing</td><td>&quot;Although in text citations and references were</td><td>[21,55,56]</td></tr><tr><td>Checking references</td><td>providpdtentialavenuerealfabriaby.a Thi stafs [56] (p. 5).</td><td>[39,50,52]</td></tr><tr><td rowspan="2">Institutional policy</td><td>anti-plagiarism guidelines Establishing</td><td>“Administrations should consider how to reshape honor codes to regulate the use of language models in general&quot;[10](p.12).</td><td>[52,56,61]</td></tr><tr><td>Providing student education</td><td>&quot;Our recommendations for students are to ... be aware of academic integrity policies and understand the consequences of academic misconduct ... provide training on academic integrity for students&quot; [52] (pp. 14-15).</td><td>[54,64,65]</td></tr></table></body></html>

Consider the issue of adopting novel question types in the task design aspect. Zhai [8] proposed exploring innovative formats that encourage students to be creative and engage in critical thinking. Choi et al. [10] emphasised the importance of requiring students to analyse cases rather than simply recalling knowledge. Similarly, Geerling et al. [22] suggested requiring students to apply the concepts that they learn in their courses and even to create new materials that AI cannot replicate. Stutz et al. [36] concluded that future assessments should focus on the higher levels of Bloom’s taxonomy, such as application, analysis, and creation [73].

Other strategies concerned the identification of AI writing and institutional policy aspects. In the former aspect, the findings of this review suggested that using AI-based writing detection tools and checking references were the two major strategies. Szabo [39] reported that although conventional plagiarism detectors failed to identify ChatGPT-generated texts, AI detectors were (still) able to detect them. Moreover, ChatGPT’s possible failure to generate a correct reference list (see Table 5) can be a telltale sign for instructors seeking to identify whether a student has used ChatGPT [50,51,56]. In addition to detecting student plagiarism, researchers have emphasised the importance of establishing anti-plagiarism guidelines and educating students about academic integrity [52,56,61].

# 4. Discussion

In this review, 50 articles published on or before 28 February 2023 were analysed. Therefore, the ChatGPT involved in these articles was its original version based on GPT-3.5, instead of GPT-4 [74]. The findings suggested that ChatGPT has the potential to enhance teaching and learning (see Tables 3 and 4). However, its knowledge and performance were not entirely satisfactory across subject domains (see Table 2). The use of ChatGPT also presents various potential issues, such as generating incorrect or fake information and student plagiarism (see Table 5). Therefore, immediate action is needed to address these potential issues (see Table 6) and optimise the use of ChatGPT in education.

# 4.1. Leveraging ChatGPT in Teaching and Learning

ChatGPT can be a valuable tool for instructors, providing a starting point for creating course syllabi, teaching materials, and assessment tasks. However, concerns regarding the accuracy of its generated content must be addressed. One possible solution would be to use ChatGPT to generate raw materials to train course-specific chatbots. For example, Topsakal and Topsakal [42] used ChatGPT to create dialogues to aid students’ English language learning. After verifying the accuracy of the materials, instructors can ask GhatGPT to convert them into a format suitable for use with AI-based chatbots, such as Google Dialogflow [75], providing students with an interactive and personalised learning environment.

ChatGPT can also enhance active learning approaches. For example, Rudolph et al. [52] suggested using flipped learning, in which students are required to prepare for lessons by studying pre-class materials. This instructional approach can free up class time for interactive learning activities, such as group discussions. In conventional flipped classes, however, students may encounter difficulties in pre-class learning [76]. In-class participation also needs to be improved [77]. This issue became apparent during the COVID-19 pandemic, during which fully online flipped learning led to poor in-class participation and disengagement from peer sharing [78,79]. As a virtual tutor, ChatGPT can assist students in online independent study by answering their questions [28] and enhance group dynamics by suggesting a discussion structure and providing real-time feedback [44].

# 4.2. Challenges and Threats Posed by ChatGPT in Education

According to Sallam [14], the use of ChatGPT in education poses challenges related to its accuracy and reliability. Because ChatGPT is trained on a large corpus of data, it may be biased or contain inaccuracies. Mbakwe et al. [57] noted that bias may stem from the use of research primarily conducted in high-income countries or textbooks that are not universally applicable. As evidenced by Pavlik [54], for example, ChatGPT is not familiar with hedge fund ownership of news media. In addition, ChatGPT’s knowledge is limited and has not (yet) been updated with data after 2021 [25,45,46]. Therefore, its responses may not always be accurate or reliable, particularly for specialised subject matters and recent events. Furthermore, ChatGPT may generate incorrect or even fake information [37,46,51]. This issue can be problematic for students who rely on ChatGPT to inform their learning.

Student plagiarism has become a significant concern in education. Plagiarism detection applications (e.g., Turnitin [71] and iThenticate [72]) are commonly used to identify copied content in student assignments. However, studies have found that ChatGPT can bypass these detectors by generating seemingly original content [61,62]. Baši´c et al. [59] provided evidence that students who used ChatGPT were more likely to commit plagiarism than those who did not use it. ChatGPT’s ability to facilitate plagiarism not only impairs academic integrity but also defeats the purpose of assessment, which is to evaluate student learning fairly. According to Cotton et al. [50], students who use ChatGPT to generate high-quality work gain an unfair advantage over their peers who do not have access to it. More importantly, instructors cannot accurately evaluate student performance when ChatGPT is involved, making it difficult to follow up on students’ learning problems.

# 4.3. Immediate Action in Response to the Impact of ChatGPT

Immediate action must be taken to mitigate the impact of ChatGPT on education. Assessment methods and institutional policies need to be updated to address the challenges posed by the emergence of AI-generated content in student assignments. Before the launch of GPT-4 (dated 14 March 2023), instructors could refine the design of their assessment tasks by incorporating multimedia resources to reduce the risk of plagiarism. The original release of ChatGPT could not process images and videos, which resulted in the missing context that increased barriers for students seeking to use it to cheat [21,34,52]. However, GPT-4, a large multimodal model created by OpenAI [74], is able to process images. Therefore, instructors have to consider other strategies, as shown in Table 6, such as incorporating digital-free components (e.g., oral presentations [40,52,58]) into their assessment tasks.

These components require students to demonstrate their abilities in real-time and in person. At the institutional level, AI-based writing detection tools should be made available to instructors. Furthermore, anti-plagiarism guidelines should be established to clarify the boundaries of ChatGPT’s involvement in student learning.

Instructor training and student education are also critical in responding to the impact of ChatGPT [64]. It is essential to train instructors on how to identify the use of ChatGPT in student assignments, which can be achieved by using AI detection tools. Instructors should also be trained on how to fully use ChatGPT in their teaching preparation and course assessment, as shown in Table 3. For students, it is crucial to introduce them to the limitations of ChatGPT, such as its reliance on biased data, limited up-to-date knowledge, and potential for generating incorrect or fake information. Therefore, instructors should teach students to use other authoritative sources (e.g., reference books) to verify, evaluate, and corroborate the factual correctness of information provided by ChatGPT [39,44]. It is also important to increase students’ awareness of academic integrity policies and their understanding of the consequences of academic misconduct [52,60]. To achieve this goal, instructors should openly discuss ChatGPT in their courses and emphasise the importance of academic honesty.

# 4.4. Limitations and Recommendations for Future Research 4.4.1. Limitations of this Rapid Review

This rapid review has limitations that must be considered when interpreting the findings. First, similar to the reviews by Mhlanga [13] and Sallam [14], the majority of the included articles were preprints, meaning that they have not undergone rigorous peer review. The quality of their evidence is, therefore, questionable. Follow-up systematic reviews are needed once more peer-reviewed articles on ChatGPT are published.

Second, most of the included articles were written in the Western context, particularly in medical and higher education. Thus, the findings of this review may be biased towards these specific contexts. Further studies in other subject domains (e.g., mathematics and language education) and education contexts (e.g., primary and secondary education) are recommended.

Third, this review only focused on the original release of ChatGPT. As a result, the findings might not be applicable to other applications of GPT and GPT-4 [74] that have been launched beyond the time period of this review. Future research can test the performance of GPT-4, explore its possibilities in supporting teaching and learning, and discuss its potential threats and solutions. Furthermore, future reviews can expand their scope to include other applications of GPT in education. By conducting more in-depth research and comprehensive reviews, educators can better understand the capabilities and limitations of GPT technology, as well as develop appropriate guidelines and policies to ensure its responsible and ethical use.

# 4.4.2. Limitations of the Included Articles

In addition to the limitations of this review, there are three major limitations associated with the included articles. First, very few studies empirically examined the influence of ChatGPT on student performance and behaviour. From the study by Baši´c et al. [59], for example, we learnt that using ChatGPT to support student writing might not improve performance but could instead lead to more plagiarism issues. However, these researchers acknowledged that the generalisability of their study was limited due to the small number of research participants $( N = 1 8 )$ . Further research is needed to evaluate the benefits and potential problems of ChatGPT-assisted learning for students.

Second, some of the suggestions made in the included articles were based on the researchers’ intuitive beliefs rather than empirical evidence. For example, some researchers [8,52,62] suggested designing assessment tasks that focus on creativity and critical thinking. However, specific strategies to achieve this goal were not always thoroughly discussed. Therefore, more rigorous studies are needed to provide evidence-based recommendations for using ChatGPT in education.

Finally, some researchers used ChatGPT to generate some of their content or suggestions, leading to repetitive ideas across articles. For example, the researchers of different articles asked ChatGPT how it can benefit teaching and learning, resulting in very similar content, such as personalised learning and language translation [8,43,45,46,48,51]. This observation provides another reason to discourage the direct adoption of ChatGPT- or AI-generated texts as personal ideas in research articles, in addition to Thorp’s [80] concern about “plagiarism of existing works” (p. 313). When ChatGPT is used as a co-author, it may generate similar points in different articles that do not acknowledge each other, which is the equivalent of self-plagiarism. If researchers plan to involve ChatGPT in writing, additional analysis of its ideas should be conducted.

# 5. Conclusions

This rapid review of 50 articles highlighted ChatGPT’s varied performance across different subject domains and its potential benefits when serving as an assistant for instructors and as a virtual tutor for students. However, its use raises various concerns, such as its generation of incorrect or fake information and the threat it poses to academic integrity. The findings of this review call for immediate action by schools and universities to update their guidelines and policies for academic integrity and plagiarism prevention. Furthermore, instructors should be trained on how to use ChatGPT effectively and detect student plagiarism. Students should also be educated on the use and limitations of ChatGPT and its potential impact on academic integrity.

Supplementary Materials: The following supporting information can be downloaded at: https://www.   
mdpi.com/article/10.3390/educsci13040410/s1, Table S1: A summary of the included articles $( N = 5 0 )$ .

Funding: This research received no external funding.

Institutional Review Board Statement: Not applicable.

Informed Consent Statement: Not applicable.

Data Availability Statement: The data samples and detailed coding procedures can be accessed by contacting the corresponding author.

Conflicts of Interest: The author declares no conflict of interest.

# References

1. Xu, L.; Sanders, L.; Li, K.; Chow, J.C.L. Chatbot for Health Care and Oncology Applications Using Artificial Intelligence and Machine Learning: Systematic Review. JMIR Cancer 2021, 7, e27850. [CrossRef] [PubMed]   
2. Zawacki-Richter, O.; Marín, V.I.; Bond, M.; Gouverneur, F. Systematic Review of Research on Artificial Intelligence Applications in Higher Education—Where are the Educators? Int. J. Educ. Technol. High. Educ. 2019, 16, 39. [CrossRef]   
3. Bengio, Y.; Lecun, Y.; Hinton, G. Deep Learning for AI. Commun. ACM 2021, 64, 58–65. [CrossRef]   
4. Aung, Y.Y.M.; Wong, D.C.S.; Ting, D.S.W. The Promise of Artificial Intelligence: A Review of the Opportunities and Challenges of Artificial Intelligence in Healthcare. Br. Med. Bull. 2021, 139, 4–15. [CrossRef]   
5. Steenbergen-Hu, S.; Cooper, H. A Meta-analysis of the Effectiveness of Intelligent Tutoring Systems on College Students’ Academic Learning. J. Educ. Psychol. 2014, 106, 331–347. [CrossRef]   
6. Afzal, S.; Dhamecha, T.; Mukhi, N.; Sindhgatta Rajan, R.; Marvaniya, S.; Ventura, M.; Yarbro, J. Development and deployment of a large-scale dialog-based intelligent tutoring system. In Proceedings of the 2019 Conference of the North American Chapter of the Association for Computational Linguistics: Human Language Technologies, Minneapolis, MN, USA, 2–7 June 2019; Association for Computational Linguistics: Stroudsburg, PA, USA, 2019; Volume 2, pp. 114–121.   
7. OpenAI. Available online: https://openai.com (accessed on 10 March 2023).   
8. Zhai, X. ChatGPT User Experience: Implications for Education. SSRN 2022, 4312418. [CrossRef]   
9. ChatGPT Passes Exams from Law and Business Schools. Available online: https://edition.cnn.com/2023/01/26/tech/chatgptpasses-exams (accessed on 10 March 2023).   
10. Choi, J.H.; Hickman, K.E.; Monahan, A.; Schwarcz, D. Chatgpt Goes to Law School. SSRN 2023, 4335905. Available online: https://ssrn.com/abstract=4335905 (accessed on 10 March 2023).   
11. ChatGPT Sets Record for Fastest-Growing User Base—Analyst Note. Available online: https://www.reuters.com/technology/ chatgpt-sets-record-fastest-growing-user-base-analyst-note-2023-02-01 (accessed on 10 March 2023). schools-ban-chatgpt-amid-fears-of-artificial-intelligence-assisted-cheating/6949800.html (accessed on 10 March 2023).   
13. Mhlanga, D. Open AI in Education, the Responsible and Ethical Use of ChatGPT Towards Lifelong Learning. SSRN 2023, 4354422. Available online: https://papers.ssrn.com/sol3/papers.cfm?abstract_id $\equiv$ 4354422 (accessed on 10 March 2023).   
14. Sallam, M. The Utility of ChatGPT as an Example of Large Language Models in Healthcare Education, Research and Practice: Systematic Review on the Future Perspectives and Potential Limitations. Available online: https://www.medrxiv.org/content/ 10.1101/2023.02.19.23286155v1 (accessed on 1 March 2023).   
15. ChatGPT Could Be a Stanford Medical Student, a Lawyer, or a Financial Analyst. Here’s a List of Advanced Exams the AI Bot Has Passed So Far. Available online: https://www.businessinsider.com/list-here-are-the-exams-chatgpt-has-passed-so-far-2023-1 (accessed on 10 March 2023).   
16. Khangura, S.; Konnyu, K.; Cushman, R.; Grimshaw, J.; Moher, D. Evidence Summaries: The Evolution of a Rapid Review Approach. Syst. Rev. 2012, 1, 10. [CrossRef] [PubMed]   
17. Tricco, A.C.; Antony, J.; Zarin, W.; Strifler, L.; Ghassemi, M.; Ivory, J.; Perrier, L.; Hutton, B.; Moher, D.; Straus, S.E. A scoping review of rapid review methods. BMC Med. 2015, 13, 224. [CrossRef]   
18. Moher, D.; Liberati, A.; Tetzlaff, J.; Altman, D.G.; The PRISMA Group. Reprint-preferred Reporting Items for Systematic Reviews and Meta-analyses: The PRISMA statement. Phys. Ther. 2009, 89, 873–880. [CrossRef]   
19. Creswell, J.W. Educational Research: Planning, Conducting, and Evaluating Quantitative and Qualitative Research, 4th ed.; Pearson: Boston, MA, USA, 2012.   
20. de Winter, J.C.F. Can ChatGPT Pass High School Exams on English Language Comprehension? Available online: https://www. researchgate.net/publication/366659237_Can_ChatGPT_pass_high_school_exams_on_English_Language_Comprehension (accessed on 1 March 2023).   
21. Susnjak, T. ChatGPT: The End of Online Exam Integrity? arXiv 2022, arXiv:2212.09292v1.   
22. Geerling, W.; Mateer, G.D.; Wooten, J.; Damodaran, N. Is ChatGPT Smarter than a Student in Principles of Economics? SSRN 2023, 4356034. [CrossRef]   
23. Hargreaves, S. ‘Words are Flowing out Like Endless Rain into a Paper Cup’: ChatGPT & Law School Assessments. SSRN 2023, 4359407. Available online: https://papers.ssrn.com/sol3/papers.cfm?abstract_id=4359407 (accessed on 10 March 2023).   
24. Kung, T.H.; Cheatham, M.; Medenilla, A.; Sillos, C.; De Leon, L.; Elepaño, C.; Madriaga, M.; Aggabao, R.; Diaz-Candido, G.; Maningo, J.; et al. Performance of ChatGPT on USMLE: Potential for AI-assisted Medical Education Using Large Language Models. PLoS Digital Health 2023, 2, e0000198. [CrossRef] [PubMed]   
25. Gilson, A.; Safranek, C.W.; Huang, T.; Socrates, V.; Chi, L.; Taylor, R.A.; Chartash, D. How does CHATGPT Perform on the United States Medical Licensing Examination? The Implications of Large Language Models for Medical Education and Knowledge Assessment. JMIR Med. Educ. 2023, 9, e45312. [CrossRef]   
26. Fijaˇcko, N.; Gosak, L.; Štiglic, G.; Picard, C.T.; Douma, M.J. Can ChatGPT Pass the Life Support Exams without Entering the American Heart Association Course? Resuscitation 2023, 185, 109732. [CrossRef]   
27. Han, Z.; Battaglia, F.; Udaiyar, A.; Fooks, A.; Terlecky, S.R. An Explorative Assessment of ChatGPT as an Aid in Medical Education: Use it with Caution. medRxiv 2023. [CrossRef]   
28. Nisar, S.; Aslam, M. Is ChatGPT a Good Tool for T&CM Students in Studying Pharmacology? SSRN 2023, 4324310. Available online: https://papers.ssrn.com/sol3/papers.cfm?abstract_id $\equiv$ 4324310 (accessed on 10 March 2023).   
29. Wang, X.; Gong, Z.; Wang, G.; Jia, J.; Xu, Y.; Zhao, J.; Fan, Q.; Wu, S.; Hu, W.; Li, X. ChatGPT Performs on the Chinese National Medical Licensing Examination. J. Med. Syst. 2023. [CrossRef]   
30. Huh, S. Are ChatGPT’s Knowledge and Interpretation Ability Comparable to Those of Medical Students in Korea for Taking a Parasitology Examination? A Descriptive Study. J. Educ. Eval. Health Prof. 2023, 20, 1. [CrossRef] [PubMed]   
31. Hisan, U.; Amri, M. ChatGPT and Medical Education: A Double-Edged Sword. J. Pedagog. Educ. Sci. 2023, 2, 71–89. [CrossRef]   
32. Mogali, S.R. Initial Impressions of ChatGPT for Anatomy Education. Anat. Sci. Educ. 2023, 1–4. [CrossRef] [PubMed]   
33. Frieder, S.; Pinchetti, L.; Griffiths, R.R.; Salvatori, T.; Lukasiewicz, T.; Petersen, P.C.; Chevalier, A.; Berner, J. Mathematical Capabilities of ChatGPT. arXiv 2023, arXiv:2301.13867.   
34. Newton, P.M. ChatGPT Performance on MCQ-based Exams. EdArXiv 2023. [CrossRef]   
35. Buchberger, B. Is ChatGPT Smarter than Master’s Applicants? Research Institute for Symbolic Computation: Linz, Austria, 2023. [CrossRef]   
36. Stutz, P.; Elixhauser, M.; Grubinger-Preiner, J.; Linner, V.; Reibersdorfer-Adelsberger, E.; Traun, C.; Wallentin, G.; Whös, K.; Zuberbühler, T. Ch(e)atGPT? An Anecdotal Approach on the Impact of ChatGPT on Teaching and Learning GIScience. EdArXiv 2023. [CrossRef]   
37. Megahed, F.M.; Chen, Y.J.; Ferris, J.A.; Knoth, S.; Jones-Farmer, L.A. How Generative AI Models such as ChatGPT Can be (Mis)Used in SPC Practice, Education, and Research? An Exploratory Study. arXiv 2023, arXiv:2302.10916.   
38. Jalil, S.; Rafi, S.; LaToza, T.D.; Moran, K.; Lam, W. ChatGPT and Software Testing Education: Promises & Perils. arXiv 2023, arXiv:2302.03287.   
39. Szabo, A. ChatGPT a Breakthrough in Science and Education: Can it Fail a Test? OSF Prepr. 2023. [CrossRef]   
40. Tlili, A.; Shehata, B.; Adarkwah, M.A.; Bozkurt, A.; Hickey, D.T.; Huang, R.; Agyemang, B. What if the Devil is My Guardian Angel: ChatGPT as a Case Study of Using Chatbots in Education. Smart Learn. Env. 2023, 10, 15. [CrossRef]   
41. Zhai, X. ChatGPT for Next Generation Science Learning. SSRN 2023, 4331313. Available online: https://ssrn.com/abstract=4331313 (accessed on 10 March 2023).   
42. Topsakal, O.; Topsakal, E. Framework for a Foreign Language Teaching Software for Children Utilizing AR, Voicebots and ChatGPT (Large Language Models). J. Cogn. Syst. 2022, 7, 33–38. [CrossRef]   
43. Ali, F. Let the Devil Speak for Itself: Should ChatGPT Be Allowed or Banned in Hospitality and Tourism Schools? J. Glob. Hosp. Tour. 2023, 2, 1–6. Available online: https://digitalcommons.usf.edu/jght/vol2/iss1/1/ (accessed on 10 March 2023).   
44. Kasneci, E.; Seßler, K.; Küchemann, S.; Bannert, M.; Dementieva, D.; Fischer, F.; Gasser, U.; Groh, G.; Günnemann, S.; Hüllermeier, E.; et al. ChatGPT for Good? On Oppor-tunities and Challenges of Large Language Models for Education. Learn. Individ. Differ. 2023, 103, 102274. [CrossRef]   
45. Khan, R.A.; Jawaid, M.; Khan, A.R.; Sajjad, M. ChatGPT—Reshaping Medical Education and Clinical Management. Pak. J. Med. Sci. 2023, 39, 605–607. [CrossRef]   
46. Baidoo-Anu, D.; Owusu Ansah, L. Education in the Era of Generative Artificial Intelligence (AI): Understanding the Potential Benefits of ChatGPT in Promoting Teaching and Learning. SSRN 2023, 4337484. Available online: https://ssrn.com/abstract=4337484 (accessed on 10 March 2023).   
47. Bishop, L. A Computer Wrote This Paper: What ChatGPT Means for Education, Research, and Writing. SSRN 2023, 4338981. Available online: https://ssrn.com/abstract=4338981 (accessed on 10 March 2023).   
48. Atlas, S. ChatGPT for Higher Education and Professional Development: A Guide to Conversational AI; University of Rhode Island: Kingston, RI, USA, 2023; Available online: https://digitalcommons.uri.edu/cba_facpubs/548 (accessed on 1 March 2023).   
49. Al-Worafi, Y.M.; Hermansyah, A.; Goh, K.W.; Ming, L.C. Artificial Intelligence Use in University: Should We Ban ChatGPT? Preprints.org 2023. [CrossRef]   
50. Cotton, D.R.; Cotton, P.A.; Shipway, J.R. Chatting and Cheating: Ensuring Academic Integrity in the Era of ChatGPT. EdArXiv 2023. [CrossRef]   
51. Qadir, J. Engineering Education in the Era of ChatGPT: Promise and Pitfalls of Generative AI for Education. TechRxiv 2023. [CrossRef]   
52. Rudolph, J.; Tan, S.; Tan, S. ChatGPT: Bullshit Spewer or the End of Traditional Assessments in Higher Education? J. Appl. Learn. Teach. 2023, 6, 1–22. [CrossRef]   
53. Pardos, Z.A.; Bhandari, S. Learning Gain Differences between ChatGPT and Human Tutor Generated Algebra Hints. arXiv 2023, arXiv:2302.06871.   
54. Pavlik, J.V. Collaborating with ChatGPT: Considering the Implications of Generative Artificial Intelligence for Journalism and Media Education. J. Mass Commun. Educ. 2023, 78, 84–93. [CrossRef]   
55. Zhang, B. Preparing Educators and Students for ChatGPT and AI Technology in Higher Education: Benefits, Limitations, Strategies, and Implications of ChatGPT & AI Technologies. Available online: https://www.researchgate.net/profile/ Bo-Zhang-376/publication/367380845_Preparing_Educators_and_Students_for_ChatGPT_and_AI_Technology_in_Higher_ EducationBenefits_Limitations_Strategies_and_Implications_of_ChatGPT_AI_Technologies/links/63d06849e922c50e99bd4d0 9/Preparing-Educators-and-Students-for-ChatGPT-and-AI-Technology-in-Higher-EducationBenefits-Limitations-Strategiesand-Implications-of-ChatGPT-AI-Technologies.pdf (accessed on 1 March 2023). [CrossRef]   
56. Perkins, M. Academic Integrity Considerations of AI Large Language Models in the Post-pandemic Era: ChatGPT and beyond. J. Univ. Teach. Learn. Pract. 2023, 20, 7. [CrossRef]   
57. Mbakwe, A.B.; Lourentzou, I.; Celi, L.A.; Mechanic, O.J.; Dagan, A. ChatGPT Passing USMLE Shines a Spotlight on the Flaws of Medical Education. PLoS Digital Health 2023, 2, e0000205. [CrossRef]   
58. King, M.R. A Conversation on Artificial Intelligence, Chatbots, and Plagiarism in Higher Education. Cell. Mol. Bioeng. 2023, 16, 1–2. [CrossRef]   
59. Baši´c, Ž.; Banovac, A.; Kruži´c, I.; Jerkovi´c, I. Better by You, Better than Me? ChatGPT-3 as Writing Assistance in Students’ Essays. arXiv 2023, arXiv:2302.04536.   
60. Ventayen, R.J.M. ChatGPT by OpenAI: Students’ Viewpoint on Cheating Using Artificial Intelligence-Based Application. SSRN 2023, 4361548. Available online: https://ssrn.com/abstract=4361548 (accessed on 10 March 2023).   
61. Khalil, M.; Er, E. Will ChatGPT Get You Caught? Rethinking of Plagiarism Detection. arXiv 2023, arXiv:2302.04335.   
62. Ventayen, R.J.M. OpenAI ChatGPT Generated Results: Similarity Index of Artificial Intelligence-Based Contents. SSRN 2023, 4332664. Available online: https://ssrn.com/abstract=4332664 (accessed on 10 March 2023).   
63. Marusenko, R. New Challenges in Assessing Students’ Knowledge: Chatbot ChatGPT and Real-Time Deepfakes. Available online: https://www.researchgate.net/profile/Roman-Marusenko/publication/368450665_New_challenges_in_assessing_students’_knowledge_chatbot_ChatGPT_and_real-time_deepfakes/links/63e815e8e2e1515b6b8bad02/New-challenges-in-assessing-studentsknowledge-chatbot-ChatGPT-and-real-time-deepfakes.pdf (accessed on 1 March 2023).   
64. García-Peñalvo, F.J. The Perception of Artificial Intelligence in Educational Contexts after the Launch of ChatGPT: Disruption or Panic? Educ. Knowl. Soc. 2023, 24, 1–9. [CrossRef]   
65. Willems, J. ChatGPT at Universities—The Least of Our Concerns. SSRN 2023, 4334162. Available online: https://ssrn.com/ abstract=4334162 (accessed on 1 March 2023).   
66. Rospigliosi, P.A. Artificial Intelligence in Teaching and Learning: What Questions Should We Ask of ChatGPT? Interact. Learn. Environ. 2023, 31, 1–3. [CrossRef]   
67. Shiri, A. ChatGPT and Academic Integrity. SSRN 2023, 4360052. Available online: https://ssrn.com/abstract=4360052 (accessed on 10 March 2023).   
68. SSRN. Available online: https://www.ssrn.com (accessed on 10 March 2023).   
69. arXiv. Available online: https://arxiv.org (accessed on 10 March 2023).   
70. ResearchGate. Available online: https://www.researchgate.net (accessed on 10 March 2023).   
71. Turnitin. Available online: https://www.turnitin.com (accessed on 10 March 2023).   
72. iThenticate. Available online: https://www.ithenticate.com (accessed on 10 March 2023).   
73. Bloom, B.S. Taxonomy of Educational Objectives: The Classification of Educational Goals; David McKay: New York, NY, USA, 1956.   
74. GPT-4. Available online: https://openai.com/research/gpt-4 (accessed on 5 April 2023).   
75. Google Cloud: Dialogflow. Available online: https://cloud.google.com/dialogflow (accessed on 10 March 2023).   
76. Lo, C.K.; Hew, K.F. A Critical Review of Flipped Classroom Challenges in K-12 Education: Possible Solutions and Recommendations for Future Research. Res. Pract. Technol. Enhanc. Learn. 2017, 12, 4. [CrossRef]   
77. Hew, K.F.; Bai, S.; Dawson, P.; Lo, C.K. Meta-analyses of Flipped Classroom Studies: A Review of Methodology. Educ. Res. Rev. 2021, 33, 100393. [CrossRef]   
78. Lo, C.K.; Hew, K.F. Design Principles for Fully Online Flipped Learning in Health Professions Education: A Systematic Review of Research During the COVID-19 Pandemic. BMC Med. Educ. 2022, 22, 720. [CrossRef]   
79. Lo, C.K. Strategies for Enhancing Online Flipped Learning: A Systematic Review of Empirical Studies During the COVID-19 pandemic. Interact. Learn. Environ. 2023, 1–29. [CrossRef]   
80. Thorp, H.H. ChatGPT is Fun, But not an Author. Science 2023, 379, 313. [CrossRef]